/** @file
This file contains functions designed to update platform SecureBoot profile

@copyright
 Copyright (c) 2013 - 2016 Intel Corporation. All rights reserved
 This software and associated documentation (if any) is furnished
 under a license and may only be used or copied in accordance
 with the terms of the license. Except as permitted by the
 license, no part of this software or documentation may be
 reproduced, stored in a retrieval system, or transmitted in any
 form or by any means without the express written consent of
 Intel Corporation.
 This file contains a 'Sample Driver' and is licensed as such
 under the terms of your license agreement with Intel or your
 vendor. This file may be modified by the user, subject to
 the additional terms of the license agreement.

@par Specification Reference:
**/
#ifndef __SECUREBOOT_PLATFORM_CONFIG_H__
#define __SECUREBOOT_PLATFORM_CONFIG_H__

#include <Protocol/FirmwareVolume2.h>

/**
  Function to Load Secure Keys from firmware volume 
  given the image GUID 

  @param[in]          ImageGuid                Image guid of the file.
  @param[in,out]      DefaultsBuffer           Buffer to return file
  @param[in,out]      DefaultsBufferSize       File size

  @retval EFI_SUCCESS              Found Key.
  @retval Others                   Key search failed.

**/
EFI_STATUS
GetX509Cert (
  IN  EFI_GUID  *ImageGuid,
  OUT VOID      **DefaultsBuffer,
  OUT UINTN     *DefaultsBufferSize
  );

/**
  Remove all secureboot keys

  @retval EFI_SUCCESS    Deleted keys successfully.
  @retval Others         Failed to delete keys

**/
EFI_STATUS
RemoveAllSecureBootKeys (
  VOID
);

/**
  Enroll a X509 certificate into Signature Database (PK, KEK, DB DBX) from 
  firmware volume

  @param[in]  CertificateGuid     Imageguid of the certificate file
  @param[in]  VariableName        Variable database to put the certificate
  @param[in]  VendorGuid          Variable owner guid
  @param[in]  SignatureOwner      Certificate owner guid

  @retval   EFI_SUCCESS            New X509 is enrolled successfully.
  @retval   EFI_OUT_OF_RESOURCES   Could not allocate needed resources.

**/
EFI_STATUS
EnrollX509FromFV (
  IN EFI_GUID   *CertificateGuid,
  IN CHAR16     *VariableName,
  IN EFI_GUID   *VendorGuid,
  IN EFI_GUID   *SignatureOwner
  );

/**
  Locate and enroll keys for selected SecureBootProfile

  @param[in] Profile       The SecureBoot profile selected 

  @retval  EFI_SUCCESS     Profile was successfully loaded
  @retval  Others          Failed 

**/
EFI_STATUS
SetPlatformSecureBootProfile (
IN       UINT8          Profile
);

#endif
